/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWField;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWModeType;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWWorkElement;
import filenet.vw.api.VWXMLData;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.api.VWXMLUtil;
import filenet.vw.server.VWFieldUtility;
import java.util.Date;

public final class VWDataField
implements IVWField {
    protected int fieldType;
    protected boolean isSystemField;
    protected String name;
    protected Object value;
    protected boolean isArray = false;
    protected int mode = 0;
    protected boolean locked = true;
    protected VWWorkElement workElement = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-04 00:20:27 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/4 $";
    }

    protected VWDataField(String fName, int fType, boolean systemField, boolean array, int theMode, VWWorkElement we) throws VWException {
        if (fName == null || fName.length() == 0) {
            throw new VWException("vw.api.DFNullName", "Data field name can not be null.");
        }
        if (!VWFieldType.isValid(fType)) {
            throw new VWException("vw.api.DFInvalidFieldType", "The field type is not a valid field type.");
        }
        this.name = fName;
        this.fieldType = fType;
        this.isSystemField = systemField;
        this.isArray = array;
        this.mode = theMode;
        this.workElement = we;
    }

    protected void internalSetValue(Object newValue) throws VWException {
        this.value = newValue;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public boolean getIsSystemField() {
        return this.isSystemField;
    }

    public boolean getIsWritable() {
        boolean isWritable = false;
        if (this.mode != 1) {
            isWritable = true;
        }
        return isWritable;
    }

    public String getName() {
        if (this.workElement != null) {
            return this.workElement.translateStr(this.name);
        }
        return this.name;
    }

    public String getAuthoredName() throws VWException {
        if (this.workElement != null) {
            return this.workElement.authorStr(this.name);
        }
        return this.name;
    }

    public Object getValue() throws VWException {
        if (this.value == null) {
            return null;
        }
        switch (this.fieldType) {
            case 1: {
                if (this.isArray) {
                    if (this.value instanceof Object[]) {
                        Object[] valArray = (Object[])this.value;
                        Integer[] array = new Integer[valArray.length];
                        for (int i = 0; i < valArray.length; ++i) {
                            array[i] = (Integer)valArray[i];
                        }
                        return array;
                    }
                    Integer[] array = new Integer[((Integer[])this.value).length];
                    System.arraycopy((Integer[])this.value, 0, array, 0, array.length);
                    return array;
                }
                return (Integer)this.value;
            }
            case 2: {
                if (this.isArray) {
                    if (this.value instanceof Object[]) {
                        Object[] valArray = (Object[])this.value;
                        String[] array = new String[valArray.length];
                        for (int i = 0; i < valArray.length; ++i) {
                            array[i] = (String)valArray[i];
                        }
                        return array;
                    }
                    String[] array = new String[((String[])this.value).length];
                    System.arraycopy((String[])this.value, 0, array, 0, array.length);
                    return array;
                }
                return this.value.toString();
            }
            case 4: {
                if (this.isArray) {
                    if (this.value instanceof Object[]) {
                        Object[] valArray = (Object[])this.value;
                        Boolean[] array = new Boolean[valArray.length];
                        for (int i = 0; i < valArray.length; ++i) {
                            array[i] = (Boolean)valArray[i];
                        }
                        return array;
                    }
                    Boolean[] array = new Boolean[((Boolean[])this.value).length];
                    System.arraycopy((Boolean[])this.value, 0, array, 0, array.length);
                    return array;
                }
                return (Boolean)this.value;
            }
            case 8: {
                if (this.isArray) {
                    if (this.value instanceof Object[]) {
                        Object[] valArray = (Object[])this.value;
                        Double[] array = new Double[valArray.length];
                        for (int i = 0; i < valArray.length; ++i) {
                            array[i] = (Double)valArray[i];
                        }
                        return array;
                    }
                    Double[] array = new Double[((Double[])this.value).length];
                    System.arraycopy((Double[])this.value, 0, array, 0, array.length);
                    return array;
                }
                return (Double)this.value;
            }
            case 16: 
            case 256: {
                if (this.isArray) {
                    if (this.value instanceof Object[]) {
                        Object[] valArray = (Object[])this.value;
                        Date[] array = new Date[valArray.length];
                        for (int i = 0; i < valArray.length; ++i) {
                            array[i] = (Date)valArray[i];
                        }
                        return array;
                    }
                    Date[] array = new Date[((Date[])this.value).length];
                    System.arraycopy((Date[])this.value, 0, array, 0, array.length);
                    return array;
                }
                return (Date)this.value;
            }
            case 32: {
                if (this.isArray) {
                    if (this.value instanceof VWAttachment[]) {
                        return this.value;
                    }
                    Object[] strs = null;
                    if (this.value instanceof Object[]) {
                        strs = (Object[])this.value;
                    }
                    if (strs == null || strs.length < 1) {
                        return null;
                    }
                    VWAttachment[] theArray = new VWAttachment[strs.length];
                    for (int i = 0; i < strs.length; ++i) {
                        theArray[i] = strs[i] != null ? new VWAttachment((String)strs[i]) : null;
                    }
                    return theArray;
                }
                if (this.value instanceof VWAttachment) {
                    return this.value;
                }
                VWAttachment newAttachment = null;
                if (this.value != null && this.value instanceof String) {
                    newAttachment = new VWAttachment((String)this.value);
                }
                return newAttachment;
            }
            case 64: {
                if (this.isArray) {
                    VWParticipant[] theArray = null;
                    Object[] arrayOfObject = null;
                    if (this.value instanceof Object[]) {
                        arrayOfObject = (Object[])this.value;
                    }
                    if (arrayOfObject == null || arrayOfObject.length < 1) {
                        theArray = new VWParticipant[]{new VWParticipant("")};
                        return theArray;
                    }
                    theArray = new VWParticipant[arrayOfObject.length];
                    for (int i = 0; i < arrayOfObject.length; ++i) {
                        if (arrayOfObject[i] != null) {
                            if (arrayOfObject[i] instanceof VWParticipant) {
                                theArray[i] = (VWParticipant)arrayOfObject[i];
                                continue;
                            }
                            theArray[i] = new VWParticipant(arrayOfObject[i].toString());
                            continue;
                        }
                        theArray[i] = new VWParticipant("");
                    }
                    return theArray;
                }
                if (this.value instanceof VWParticipant) {
                    return this.value;
                }
                VWParticipant newParticipant = null;
                if (this.value != null && this.value instanceof String) {
                    newParticipant = new VWParticipant((String)this.value);
                }
                return newParticipant;
            }
            case 128: {
                if (this.isArray) {
                    if (this.value instanceof VWXMLData[]) {
                        return this.value;
                    }
                    Object[] strs = null;
                    if (this.value instanceof Object[]) {
                        strs = (Object[])this.value;
                    }
                    if (strs == null || strs.length < 1) {
                        return null;
                    }
                    VWXMLData[] theArray = new VWXMLData[strs.length];
                    for (int i = 0; i < strs.length; ++i) {
                        theArray[i] = strs[i] != null ? new VWXMLData((String)strs[i], null, null, true) : null;
                    }
                    return theArray;
                }
                if (this.value instanceof VWXMLData) {
                    return this.value;
                }
                VWXMLData newXML = null;
                if (this.value != null && this.value instanceof String) {
                    newXML = new VWXMLData((String)this.value, null, null, true);
                }
                return newXML;
            }
            case 512: {
                if (this.isArray) {
                    if (this.value instanceof VWGuid[]) {
                        return this.value;
                    }
                    Object[] strs = null;
                    if (this.value instanceof Object[]) {
                        strs = (Object[])this.value;
                    }
                    if (strs == null || strs.length < 1) {
                        return null;
                    }
                    VWGuid[] theArray = new VWGuid[strs.length];
                    for (int i = 0; i < strs.length; ++i) {
                        theArray[i] = strs[i] != null ? new VWGuid((String)strs[i]) : null;
                    }
                    return theArray;
                }
                if (this.value instanceof VWGuid) {
                    return this.value;
                }
                VWGuid newGuid = null;
                if (this.value != null && this.value instanceof String) {
                    newGuid = new VWGuid((String)this.value);
                }
                return newGuid;
            }
        }
        return null;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setValue(Object newValue) throws VWException {
        if (this.isSystemField) {
            throw new VWException("vw.api.FOSetFieldValueSystemField", "System Fields cannot be set. {0}", this.name);
        }
        newValue = VWFieldUtility.convertFieldValue(newValue, this.fieldType, this.name, this.isArray);
        this.internalSetValue(newValue);
    }

    public String toString() {
        if (this.value != null) {
            if (this.isArray) {
                try {
                    return VWArrayHandler.runtimeConvertArrayToString(this.value);
                }
                catch (Exception ex) {
                    return "Error converting array value to string";
                }
            }
            switch (this.fieldType) {
                case 16: 
                case 256: {
                    return VWFieldUtility.convertDateToString(this.value);
                }
            }
            return this.value.toString();
        }
        return null;
    }

    public String getStringValue() {
        return this.toString();
    }

    public int getMode() {
        return this.mode;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t";
        String ATTRIB_INDENT2 = ATTRIB_INDENT + "\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWDataFieldNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t<Field\n");
        theBuffer.append(ATTRIB_INDENT + "Name=\"" + VWXMLHandler.toXMLString(this.getName()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "Type=\"" + VWFieldType.typeToString(this.fieldType) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "IsSystemField=\"" + VWXMLHandler.booleanToString(this.isSystemField) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "Mode=\"" + VWModeType.typeToString(this.mode) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "IsArray=\"" + VWXMLHandler.booleanToString(this.isArray) + "\"");
        theBuffer.append(">");
        switch (this.fieldType) {
            case 32: {
                theBuffer.append("\n<Attachments");
                if (this.value != null) {
                    theBuffer.append(">");
                    theBuffer.append("\n" + ATTRIB_INDENT);
                    VWAttachment tmpA = null;
                    if (!this.isArray) {
                        if (this.value instanceof VWAttachment) {
                            ((VWAttachment)this.value).toXML(theBuffer);
                        } else {
                            tmpA = new VWAttachment();
                            tmpA.setValue((String)this.value);
                            tmpA.toXML(theBuffer);
                        }
                    } else {
                        int arrayCount = ((Object[])this.value).length;
                        if (this.value instanceof VWAttachment[]) {
                            for (int i = 0; i < arrayCount; ++i) {
                                ((VWAttachment[])this.value)[i].toXML(theBuffer);
                            }
                        } else {
                            for (int i = 0; i < arrayCount; ++i) {
                                tmpA = new VWAttachment();
                                tmpA.setValue((String)((Object[])this.value)[i]);
                                tmpA.toXML(theBuffer);
                            }
                        }
                    }
                    theBuffer.append("</Attachments>");
                    break;
                }
                theBuffer.append("/>");
                break;
            }
            case 64: {
                theBuffer.append("\n" + ATTRIB_INDENT + "<Values");
                if (this.value != null) {
                    theBuffer.append(">");
                    int arrayCount = ((Object[])this.value).length;
                    for (int i = 0; i < arrayCount; ++i) {
                        if (((Object[])this.value)[i] instanceof VWParticipant) {
                            VWParticipant tmpPar = (VWParticipant)((Object[])this.value)[i];
                            tmpPar.toXML(theBuffer);
                            continue;
                        }
                        theBuffer.append("\n" + ATTRIB_INDENT2 + "<Value>" + VWXMLHandler.toXMLString(((Object[])this.value)[i].toString()) + "</Value>");
                    }
                    theBuffer.append("\n" + ATTRIB_INDENT + "</Values>");
                    break;
                }
                theBuffer.append("/>");
                break;
            }
            default: {
                theBuffer.append("\n" + ATTRIB_INDENT + "<Values");
                if (this.value != null) {
                    theBuffer.append(">");
                    if (!this.isArray) {
                        if (this.value instanceof Date) {
                            theBuffer.append("\n" + ATTRIB_INDENT2 + "<Value>" + VWXMLHandler.toXMLString(VWXMLUtil.convertDateToUTCString((Date)this.value)) + "</Value>");
                        } else {
                            theBuffer.append("\n" + ATTRIB_INDENT2 + "<Value>" + VWXMLHandler.toXMLString(this.value.toString()) + "</Value>");
                        }
                    } else {
                        int arrayCount = ((Object[])this.value).length;
                        for (int i = 0; i < arrayCount; ++i) {
                            if (((Object[])this.value)[i] instanceof Date) {
                                theBuffer.append("\n" + ATTRIB_INDENT2 + "<Value>" + VWXMLHandler.toXMLString(VWXMLUtil.convertDateToUTCString((Date)((Object[])this.value)[i])) + "</Value>");
                                continue;
                            }
                            theBuffer.append("\n" + ATTRIB_INDENT2 + "<Value>" + VWXMLHandler.toXMLString(((Object[])this.value)[i].toString()) + "</Value>");
                        }
                    }
                    theBuffer.append("\n" + ATTRIB_INDENT + "</Values>");
                    break;
                }
                theBuffer.append("/>");
            }
        }
        theBuffer.append("\n\t</Field>\n");
    }
}

